// Card View //
///////////////

#include "Card View.h"
#include "Dialogs.h"
#include "Library.h"
#include <stdio.h>

static const int DEFWIDTH = WIDTHX + (GetSystemMetrics (SM_CXFRAME) * 2) + (GetSystemMetrics (SM_CXDLGFRAME) * 2);
static const int DEFHEIGHT = GetSystemMetrics (SM_CYSCREEN) / 2;

void FreeCardView ();
BOOL LocateCardView (int x, int y);

void CardView::Create (int card)
{
    const int TILES = 8;
    const int OFFSET = 32;
    static int Next = 0;
    RECT rect;
    int index, x, y;
    BOOL open;

    index = 0;
    open = FALSE;

    while ((index < TILES) && !open) {
        x = (GetSystemMetrics (SM_CXSCREEN) - 1) - (index * OFFSET);
        y = index * OFFSET;
       open = !LocateCardView (x, y);
       index ++;
    }

    if (!open) {
        x = (GetSystemMetrics (SM_CXSCREEN) - 1) - (Next * OFFSET);
        y = Next * OFFSET;
        Next = ++Next % TILES;
    }

    rect.right = x;
    rect.left = rect.right - DEFWIDTH;
    rect.top = y;
    rect.bottom = rect.top + DEFHEIGHT;
    Create (card, rect);
}

void CardView::Create (int card, int x, int y)
{
    RECT rect;

    rect.left = x;
    rect.right = rect.left + DEFWIDTH;
    rect.top = y;
    rect.bottom = rect.top + DEFHEIGHT;

    Create (card, rect);
}

void CardView::Create (int key, const RECT& target)
{
    static epp_Class Class;
    static epp_Icon Icon;
    int xmax = GetSystemMetrics (SM_CXSCREEN) - 1;
    int ymax = GetSystemMetrics (SM_CYSCREEN) - 1;
    RECT rect;

    if (!Class) {
        Icon.LoadIcon (IDI_CARD);
        Class.Create (0, LoadCursor (NULL, IDC_ARROW), NULL, Icon);
    }

    rect = target;

    if (rect.left < 0)
        OffsetRect (&rect, rect.left, 0);

    if (rect.right > xmax)
        OffsetRect (&rect, xmax - rect.right, 0);

    if (rect.bottom < 0)
        OffsetRect (&rect, 0, rect.right);

    if (rect.bottom > ymax)
        OffsetRect (&rect, 0, ymax - rect.bottom);

    epp_Frame::Create (0, Class, NULL, WS_OVERLAPPEDWINDOW, rect, NULL);
    Card = key & KEYMASK;
    SetTitle ();
    Views.Add (this);
    UpdateWindow ();
}

void CardView::SetTitle ()
{
    char title [256];
    CARD_INFO card;

    Library.Find (Card, card);
	LoadString (IDS_SINGLETITLE, title);
	strcat (title, card.Name);
	SetWindowText (title);
}

char CardView::Sort ()
{
    return ORDER_CARD;
}

void CardView::Hide ()
{
    Delete (NULL);
}

void CardView::Delete (HWND)
{
    Close ();
}

void CardView::Drop (int card)
{
    Card = card & KEYMASK;
    SetTitle ();
    Card.InvalidateRect ();
    SetForegroundWindow ();
    Views.Refresh (this);
}

void CardView::Rename (HWND)
{
}

void CardView::ModifyCard (int key)
{
    if (key == Card) {
        SetTitle ();
        Card.InvalidateRect ();
        Views.Refresh (this);
    }
}

void CardView::DeleteCard (int key)
{
    if (key == Card)
        PostMessage (ITEM_CLOSE);
}

void CardView::Load (istream&)
{
}

void CardView::LoadData (istream&)
{
}

void CardView::Save (ostream&)
{
}

void CardView::SaveData (ostream&)
{
}

HMENU CardView::GetMenu ()
{
    return ViewMenu;
}

int CardView::GetCard ()
{
    return Card;
}

static DWORD pascal ModifyDecks (void *param)
{
    Views.Modify ((int) param);
    BusyEnd ();
    return 0;
}

void CardView::Modify ()
{
    CardDialog dialog;
    epp_Thread thread;
    CARD_INFO card;

    Library.Find (Card, card);

    if (dialog.Run (&card, *this) && strlen (card.Name)) {
        Library.Update (card);
        thread.Create (ModifyDecks, (void *) (int) Card);
        BusyBegin (IDS_MODIFYCARD, *this);
    }
}

static DWORD pascal UpdateDecks (void *param)
{
    Views.Delete ((int) param);
    BusyEnd ();
    return 0;
}

void CardView::Delete ()
{
    epp_Thread thread;
    char message [256];
    CARD_INFO card;

    Library.Find (Card, card);

    sprintf (message, "Delete card \"%s\"?", card.Name);

    if (Check (message, *this)) {
        Library.Delete (Card);
        thread.Create (UpdateDecks, (void *) (int) Card);
        BusyBegin (IDS_DELETECARD, *this);
    }
}

void CardView::OnCommand (int notify, int id, HWND)
{
    switch (id) {
        case IDM_CARD_NEW:
            Views.NewCard (*this);
            break;
        case IDM_CARD_MODIFY:
        case IDM_CARDPOP_MODIFY:
            Modify ();
            break;
        case IDM_CARD_DELETE:
            Delete ();
            break;
        case IDM_CARD_MAIN:
            Views.ShowWindow (SW_NORMAL);
            Views.SetForegroundWindow ();
            break;
        case IDM_CARD_CLOSE:
            Hide ();
            break;
    }
}

int CardView::OnCreate (CREATESTRUCT *)
{
    RECT rect;

	Menu.LoadMenu (IDR_CARD);
	ViewMenu.LoadMenu (IDR_MAINPOPCARD);
	SetMenu (Menu);

    GetClientRect (&rect);
    Card.Create (rect, *this, this);
    Forward ();
    return 0;
}

void CardView::OnDestroy ()
{
    Views.Remove (this);
    FreeCardView ();
}

BOOL CardView::OnEraseBkgnd (HDC)
{
    return TRUE;
}

void CardView::OnLButtonDblClk (int, int, int)
{
    Modify ();
}

void CardView::OnSize (int, int, int)
{
    RECT rect;

    GetClientRect (&rect);
    Card.MoveWindow (rect);
    Forward ();
}

BEGIN_HANDLER (CardView, ViewItem)
    ON_WM_ERASEBKGND
    ON_WM_SIZE
    ON_WM_COMMAND
    ON_WM_LBUTTONDBLCLK
    ON_WM_CREATE
    ON_WM_DESTROY
END_HANDLER

// allocator

static const int MAXVIEWS = 100;
static int ViewCount = 0;
static CardView CardViews [MAXVIEWS];

CardView * AllocCardView ()
{
    int index;

    if (ViewCount >= MAXVIEWS)
        return NULL;

    index = 0;
    while (CardViews [index])
        index ++;

    ViewCount ++;
    return &CardViews [index];
}

void FreeCardView ()
{
    ViewCount --;
}

BOOL LocateCardView (int x, int y)
{
    RECT rect;
    int index;
    BOOL found;

    index = 0;
    found = FALSE;

    while ((index < MAXVIEWS) && !found) {
        if (CardViews [index]) {
            rect = CardViews [index];
            if ((rect.right == x) && (rect.top == y))
                found = TRUE;
        }
        index ++;
    }

    return found;
}